<?php

namespace Intergo\CommonSending\DataTransferObjects;

use Intergo\CommonSending\Enums\ChannelEnum;
use Intergo\CommonSending\Enums\DirectionEnum;
use Intergo\CommonSending\Enums\MessageStatusEnum;
use Intergo\CommonSending\Enums\ProductClassificationEnum;
use Intergo\CommonSending\Enums\QueuePriorityEnum;
use Intergo\CommonSending\Enums\SendingSourceEnum;

class MessageDTO
{
    public string $internal_id;
    public ?string $external_id;
    public ?string $campaign_id = null;
    public int $user_id;
    public ?string $sender_id;
    public string $status = MessageStatusEnum::SENDING_STATUS;

    public string $send_from = SendingSourceEnum::API;
    public int $sms_count;
    public ?int $scheduled_for = 0;
    public ?string $callback_url;
    public string $created_at;
    public ?string $sent_at;
    public ?string $timezone;
    public ?int $product_id;
    public float $client_cost;
    public float $client_cost_in_eur;
    public string $country_code;
    public ?string $currency;
    public ?int $mcc_mnc;
    public int $priority = QueuePriorityEnum::MEDIUM;
    public bool $transcode;
    public ?string $user_queue;
    public ?string $opt_out_code;

    public ?string $failed_reason = null;
    public ?string $internal_failed_reason = null;

    public string $direction = DirectionEnum::MOBILE_TERMINATED;
    public string $channel = ChannelEnum::SMS;
    public string $product_classification = ProductClassificationEnum::MARKETING;

    /**
     * @param array $data
     */
    public function __construct(array $data) {
        foreach ($data as $key => $value) {
            if (property_exists($this, $key)) {
                $this->$key = $value;
            }
        }
    }

    /**
     * @return array
     */
    public function toArray(): array {
        return get_object_vars($this);
    }
}
