<?php

namespace Intergo\CommonSending\DataTransferObjects;

class ViberMessageDTO
{
    public $to;
    public ?string $message;

    public int $viber_type;

    public ?string $viber_image_url = null;
    public ?string $viber_target_url = null;
    public ?string $viber_caption = null;
    public ?string $ttl = null;
    public ?string $template_id = null;
    public ?string $tracking_data = null;
    public ?MessageDTO $messageVO;

    /**
     * @param array $data
     */
    public function __construct(array $data)
    {
        $this->messageVO = new MessageDTO($data);
        foreach ($data as $key => $value) {
            if (property_exists($this, $key)) {
                $this->$key = $value;
            }
        }
    }

    /**
     * @return array
     */
    public function toArray(): array
    {
        return get_object_vars($this);
    }
}
