<?php

namespace Intergo\CommonSending\Enums;

class ViberType
{
    const TRANSACTIONAL_TEXT = 106;
    const TRANSACTIONAL_TEXT_TWO_WAY = 206;
    const PROMOTIONAL_IMAGE = 107;
    const PROMOTIONAL_TEXT_IMAGE_BUTTON = 108;
    const PROMOTIONAL_TEXT_BUTTON = 109;
    const PROMOTIONAL_IMAGE_TWO_WAY = 207;
    const PROMOTIONAL_TEXT_IMAGE_BUTTON_TWO_WAY = 210;
    const PROMOTIONAL_TEXT_BUTTON_TWO_WAY = 209;

    /**
     * @return string[]
     */
    public static function texts(): array
    {
        return [
            ViberType::TRANSACTIONAL_TEXT => 'Transactional Text',
            ViberType::TRANSACTIONAL_TEXT_TWO_WAY => 'Transactional Text 2 Way',
            ViberType::PROMOTIONAL_IMAGE => 'Promotional Image',
            ViberType::PROMOTIONAL_IMAGE_TWO_WAY => 'Promotional Image 2 Way',
            ViberType::PROMOTIONAL_TEXT_BUTTON => 'Promotional Text Button',
            ViberType::PROMOTIONAL_TEXT_BUTTON_TWO_WAY => 'Promotional Text Button 2 Way',
            ViberType::PROMOTIONAL_TEXT_IMAGE_BUTTON => 'Promotional Text Image Button',
            ViberType::PROMOTIONAL_TEXT_IMAGE_BUTTON_TWO_WAY => 'Promotional Text Image Button 2 Way',
        ];
    }

    /**
     * @param $type
     * @return string
     */
    public static function getText($type): string
    {
        return self::texts()[$type] ?? 'N/A';
    }

    /**
     * @return array
     */
    public function supportedTypes(): array
    {
        return [
            ViberType::TRANSACTIONAL_TEXT => self::getText(ViberType::TRANSACTIONAL_TEXT),
            ViberType::PROMOTIONAL_TEXT_IMAGE_BUTTON => self::getText(ViberType::PROMOTIONAL_TEXT_IMAGE_BUTTON),
            ViberType::PROMOTIONAL_TEXT_BUTTON => self::getText(ViberType::PROMOTIONAL_TEXT_BUTTON),

        ];
    }
}
