<?php

namespace Intergo\CommonSending\Traits;

use Intergo\CommonSending\Enums\ChannelEnum;
use Intergo\CommonSending\Enums\FallbackExpirationEnum;

trait HasBaseViberFields
{
    public int $viber_type;
    public ?int $ttl = FallbackExpirationEnum::DEFAULT_TTL;
    public ?bool $is_free = false;

    public function initializeViber()
    {
        $this->channel = ChannelEnum::VIBER;
    }

    public function getViberType(): int
    {
        return $this->viber_type;
    }

    public function getViberExpirationTime(): ?int
    {
        return $this->ttl;
    }

    public function getTrackingData(): ?string
    {
        return $this->tracking_data;
    }
}
