<?php

namespace Intergo\CommonSending\DataTransferObjects\Messages\Otp;

use Intergo\CommonSending\DataTransferObjects\Messages\AbstractMessageDTO;
use Intergo\CommonSending\DataTransferObjects\Messages\MessageInterface;
use Intergo\CommonSending\Traits\HasBaseViberFields;
use Intergo\CommonSending\Traits\HasFallback;

class ViberOtpDTO extends AbstractOtpMessageDTO implements MessageInterface
{
    use HasBaseViberFields, HasFallback;

    /**
     * @param array $data
     */
    public function __construct(array $data)
    {
        $this->initializeViber();
        $this->initializeFallback($data);
        parent::__construct($data);
    }

    public function messageDTO(): AbstractMessageDTO
    {
        return $this->messageDTO;
    }
}
