<?php

namespace Intergo\CommonSending\Enums;

class QueuePriorityEnum
{
    const HIGHEST = 3;
    const HIGH = 2;
    const MEDIUM = 1;
    const LOW = 0;

    /**
     * @param int $count
     * @return int
     */
    public static function get(int $count = 1): int
    {
        if ($count > 1000) {
            return self::LOW;
        } elseif ($count > 20) {
            return self::MEDIUM;
        } elseif ($count > 1) {
            return self::HIGH;
        }
        return self::HIGHEST;
    }
}