<?php

namespace Intergo\CommonSending\DataTransferObjects;

use Intergo\CommonSending\Enums\ChannelEnum;
use Intergo\CommonSending\Enums\FallbackExpirationEnum;
use Intergo\CommonSending\Enums\ProductClassificationEnum;
use Intergo\CommonSending\Enums\ViberType;

class ViberMessageDTO
{
    public int $viber_type;

    public ?string $image_url = null;
    public ?string $button_url = null;
    public ?string $button_text = null;

    public ?int $ttl = FallbackExpirationEnum::DEFAULT_TTL;
    public ?string $template_id = null;
    public ?string $tracking_data = null;
    public ?bool $is_free = false;
    public ?bool $is_otp = false;
    public ?bool $should_fallback = false;
    public ?MessageDTO $messageVO;

    /**
     * @param array $data
     */
    public function __construct(array $data)
    {
        $this->messageVO = new MessageDTO($data);
        foreach ($data as $key => $value) {
            if (property_exists($this, $key)) {
                $this->$key = $value;
            }
        }

        //scheduled viber message is not supported for the initial release
        $this->messageVO->scheduled_for =null;

        $this->messageVO->channel = ChannelEnum::VIBER;
        if ($this->viber_type== ViberType::TRANSACTIONAL_TEXT || $this->viber_type== ViberType::TRANSACTIONAL_TEXT_TWO_WAY) {
            $this->messageVO->product_classification = ProductClassificationEnum::TRANSACTIONAL;
        }
        else{
            $this->messageVO->product_classification = ProductClassificationEnum::MARKETING;
        }
    }

    /**
     * @return array
     */
    public function toArray(): array
    {
        return get_object_vars($this);
    }
}
