<?php

namespace Intergo\CommonSending\Jobs;

use Illuminate\Bus\Batchable;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Intergo\CommonSending\DataTransferObjects\MessageDTO;

class BaseOTPFallbackJob implements ShouldQueue
{

    use Batchable, InteractsWithQueue, Queueable, SerializesModels;
    public string $trace_id;
    protected $fallbackDTOs;
    /**
     * Create a new job instance.
     *
     * @param MessageDTO $messageDTO
     * @param string $traceId
     */
    public function __construct($fallbackDTOs, string $traceId)
    {
        $this->fallbackDTOs = $fallbackDTOs;
        $this->trace_id = $traceId;
    }

    /**
     * @return void
     */
    public function handle()
    {
        //
    }

}
