<?php

namespace Intergo\CommonSending\Jobs;

use Illuminate\Bus\Batchable;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Intergo\CommonSending\DataTransferObjects\MessageDTO;

class BaseFallbackJob implements ShouldQueue
{

    use Batchable, InteractsWithQueue, Queueable, SerializesModels;
    protected string $trace_id;
    public int $priority;
    protected MessageDTO $messageDTO;
    private string $phoneNumber;

    /**
     * Create a new job instance.
     *
     * @param MessageDTO $messageDTO
     * @param int $priority
     * @param string $traceId
     */
    public function __construct(MessageDTO $messageDTO, int $priority, string $traceId)
    {
        $this->messageDTO = $messageDTO;
        $this->phoneNumber = $messageDTO->to;
        $this->priority = $priority;
        $this->trace_id = $traceId;
        parent::__construct();
    }

    /**
     * @return void
     */
    public function handle()
    {
        //
    }

}
