<?php

namespace Intergo\CommonSending\DataTransferObjects;

use Intergo\CommonSending\Enums\ChannelEnum;
use Intergo\CommonSending\Enums\FallbackExpirationEnum;
use Intergo\CommonSending\Enums\ProductClassificationEnum;
use Intergo\CommonSending\Enums\ViberType;

class WhatsAppMessageDTO
{

    public ?int $ttl = FallbackExpirationEnum::DEFAULT_TTL;
    public ?string $trace_id = null;
    public ?MessageDTO $messageVO;

    /**
     * @param array $data
     */
    public function __construct(array $data,string $trace_id)
    {
        $this->trace_id = $trace_id;
        $this->messageVO = new MessageDTO($data);
        foreach ($data as $key => $value) {
            if (property_exists($this, $key)) {
                $this->$key = $value;
            }
        }
    }

    /**
     * @return array
     */
    public function toArray(): array
    {
        return get_object_vars($this);
    }
}
