<?php

namespace Intergo\CommonSending\DataTransferObjects\Messages\Otp;

use Intergo\CommonSending\DataTransferObjects\Messages\AbstractMessageDTO;
use Intergo\CommonSending\Enums\ProductClassificationEnum;
use Intergo\CommonSending\Enums\QueuePriorityEnum;

abstract class AbstractOtpMessageDTO extends AbstractMessageDTO
{
    public string $to;
    public int $priority = QueuePriorityEnum::HIGHEST;
    public string $product_classification = ProductClassificationEnum::OTP;

    public function getRecipient(): string
    {
        return $this->to;
    }

    public function isOTP(): bool
    {
        return true;
    }
}
