<?php

namespace Intergo\CommonSending\Traits;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\Response;

trait ResponseTrait
{
    /**
     * @param string $message
     * @param array $data
     * @param int $status
     * @return JsonResponse
     */
    private function success(string $message = '', array $data = [], int $status = Response::HTTP_OK): JsonResponse
    {
        return $this->response(true, $message, $data, $status);
    }

    /**
     * @param string $message
     * @param array $data
     * @param int $status
     * @return JsonResponse
     */
    private function failed(
        string $message = '',
        array $data = [],
        int $status = Response::HTTP_BAD_REQUEST
    ): JsonResponse {
        return $this->response(false, $message, $data, $status);
    }

    /**
     * @param bool $success
     * @param string $response
     * @param array $data
     * @param int $status
     * @return JsonResponse
     */
    private function response(
        bool $success = true,
        string $response = '',
        array $data = [],
        int $status = Response::HTTP_OK
    ): JsonResponse {
        unset($data['statusCode'], $data['message']);

        return response()->json(compact('success', 'response', 'data'), $status);
    }
}
