<?php

namespace Intergo\CommonSending\Jobs;

use Illuminate\Bus\Batchable;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Intergo\CommonSending\DataTransferObjects\MessageDTO;

class BaseFallbackJob implements ShouldQueue
{

    use Batchable, InteractsWithQueue, Queueable, SerializesModels;
    public string $trace_id;
    public int $priority;
    protected MessageDTO $messageDTO;
    protected string $phoneNumber;

    /**
     * Create a new job instance.
     *
     * @param MessageDTO $messageDTO
     * @param string $traceId
     */
    public function __construct(MessageDTO $messageDTO, string $traceId)
    {
        $this->messageDTO = $messageDTO;
        $this->phoneNumber = $messageDTO->to;
        $this->priority = $messageDTO->priority;
        $this->trace_id = $traceId;
    }

    /**
     * @return void
     */
    public function handle()
    {
        //
    }

}
