<?php

namespace Intergo\CommonSending\Jobs;

use Illuminate\Bus\Batchable;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Intergo\CommonSending\DataTransferObjects\Messages\SMS\SmsMessageDTO;

class BaseFallbackJob implements ShouldQueue
{

    use Batchable, InteractsWithQueue, Queueable, SerializesModels;
    public string $trace_id;
    public int $priority;
    protected SmsMessageDTO $messageDTO;
    protected string $phoneNumber;

    /**
     * Create a new job instance.
     *
     * @param SmsMessageDTO $messageDTO
     * @param string $traceId
     */
    public function __construct(SmsMessageDTO $messageDTO, string $traceId)
    {
        $this->messageDTO = $messageDTO;
        $this->phoneNumber = $messageDTO->recipient;
        $this->priority = $messageDTO->priority;
        $this->trace_id = $traceId;
    }

    /**
     * @return void
     */
    public function handle()
    {
        //
    }

}
