<?php

namespace Intergo\CommonSending\Helpers;

use Intergo\CommonSending\Exceptions\InvalidSenderIdException;

class SenderIdValidator
{
    /**
     * @param $senderId
     * @throws InvalidSenderIdException
     */
    public static function validateViber($senderId)
    {
        if (!empty($senderId)) {
            // allow + if is a rented number
            $pregString = '/^[a-zA-Z0-9-._\s&]+$/i';

            // Sender ID can have only letters, digits and spaces:
            if (!preg_match($pregString, $senderId)) {
                throw new InvalidSenderIdException('Sender ID can only contain alphanumeric characters and spaces.', 400);
            }

            // it cannot have more than 35 characters:
            if (strlen($senderId) > 35) {
                throw new InvalidSenderIdException('The Sender ID cannot contain more than 35 characters.', 400);
            }
        } else {
            throw new InvalidSenderIdException('Empty sender ID.', 400);
        }
    }

    /**
     * @param $senderId
     * @return void
     * @throws InvalidSenderIdException
     */
    public static function validate($senderId)
    {
        // allow + if is a rented number
        $pregString = '/^[a-zA-Z0-9-_\s&]+$/i';
        // Sender ID can have only letters, digits and spaces:
        if (!preg_match($pregString, $senderId)) {
            throw new InvalidSenderIdException('Sender ID can only contain alphanumeric characters and spaces.', 400);
        }
        // If it has digits only (no letters and spaces) - it cannot have more than 16 digits:
        if (preg_match('/^[0-9]+$/', $senderId) && strlen($senderId) > 16) {
            throw new InvalidSenderIdException('The numeric Sender ID cannot contain more than 16 digits.',
                                                    400);
        }
        // If it contains letters or spaces - it cannot have more than 11 characters:
        if (preg_match('/[a-z-_\s&]/i', $senderId) && strlen($senderId) > 11) {
            throw new InvalidSenderIdException('The alphanumeric Sender ID cannot contain more than 11 characters.',
                                                    400);
        }
    }

}