<?php

namespace Intergo\CommonSending\DataTransferObjects\Messages\Single;

use Intergo\CommonSending\Enums\ChannelEnum;
use Intergo\CommonSending\Enums\ProductClassificationEnum;
use Intergo\CommonSending\Enums\ViberType;
use Intergo\CommonSending\Traits\ViberTrait;

class ViberMessageDTO extends AbstractSingleMessageDTO
{
    use ViberTrait;

    /**
     * @param array $data
     */
    public function __construct(array $data)
    {
        $this->messageVO = new MessageDTO($data);
        parent::__construct($data);

        //scheduled viber message is not supported for the initial release
        $this->messageVO->scheduled_for = null;

        $this->messageVO->channel = ChannelEnum::VIBER;
        if ($this->viber_type == ViberType::TRANSACTIONAL_TEXT || $this->viber_type == ViberType::TRANSACTIONAL_TEXT_TWO_WAY) {
            $this->messageVO->product_classification = ProductClassificationEnum::TRANSACTIONAL;
        } else {
            $this->messageVO->product_classification = ProductClassificationEnum::MARKETING;
        }
    }
}
