<?php

namespace Intergo\CommonSending\Enums;

class QueuePriorityEnum
{
    const HIGHEST = 3;
    const HIGH = 2;
    const MEDIUM = 1;
    const LOW = 0;

    /**
     * @param int $count
     * @return int
     */
    public static function get(int $count): int
    {
        $priority = self::HIGHEST;
        if ($count > 1) {
            $priority = self::HIGH;
        }
        if ($count > 20) {
            $priority = self::MEDIUM;
        }
        if ($count > 1000) {
            $priority = self::LOW;
        }
        return $priority;
    }
}