<?php

namespace Intergo\CommonGlobal\Traits;

use Illuminate\Http\JsonResponse;
use Symfony\Component\HttpFoundation\Response;
use Throwable;

trait ResponseTrait
{
    /**
     * @param string $message
     * @param array $data
     * @param int $status
     * @return JsonResponse
     */
    private function success(string $message = '', array $data = [], int $status = Response::HTTP_OK): JsonResponse
    {
        return $this->response(true, $message, $data, $status);
    }

    /**
     * @param string|null $message
     * @param Throwable|null $throwable
     * @return JsonResponse
     */
    private function failed(
        string $message = null,
        Throwable $throwable = null
    ): JsonResponse {
        $message = $message ?? $throwable->getMessage();
        $trace = $throwable->getTrace();
        $status = !empty($throwable->getCode()) ? $throwable->getCode() : Response::HTTP_INTERNAL_SERVER_ERROR;
        $data = array_slice(array_map(function ($item) {
            return array_intersect_key($item, array_flip(['file', 'line', 'function', 'class']));
        }, $trace), 0, 5);
        return $this->response(false, $message, $data, $status);
    }

    /**
     * @param bool $success
     * @param string $message
     * @param array $data
     * @param int $status
     * @return JsonResponse
     */
    private function response(
        bool $success = true,
        string $message = '',
        array $data = [],
        int $status = Response::HTTP_OK
    ): JsonResponse {
        unset($data['statusCode'], $data['message']);

        return response()->json(compact('success', 'message', 'data'), $status);
    }
}
