<?php

namespace Intergo\BaseClient\Responses;

class PaginationResponse extends AbstractBaseResponse
{
    /**
     * @var array
     */
    protected $links;

    /**
     * @var int
     */
    protected $current_page;

    /**
     * @var int
     */
    protected $from;

    /**
     * @var int
     */
    protected $last_page;

    /**
     * @var string
     */
    protected $path;

    /**
     * @var int
     */
    protected $per_page;

    /**
     * @var int
     */
    protected $to;

    /**
     * @var int
     */
    protected $total;

    /**
     * @param array $response
     */
    public function __construct(array $response)
    {
        $this->links = $response['links'] ?? null;
        $this->current_page = $response['current_page'] ?? null;
        $this->from = $response['from'] ?? null;
        $this->last_page = $response['last_page'] ?? null;
        $this->path = $response['path'] ?? null;
        $this->per_page = $response['per_page'] ?? null;
        $this->to = $response['to'] ?? null;
        $this->total = $response['total'] ?? null;

        parent::__construct($response);
    }

    /**
     * @return array
     */
    public function getLinks(): array
    {
        return $this->links;
    }

    /**
     * @return int
     */
    public function getCurrentPage(): int
    {
        return $this->current_page;
    }

    /**
     * @return int
     */
    public function getFrom(): int
    {
        return $this->from;
    }

    /**
     * @return int
     */
    public function getLastPage(): int
    {
        return $this->last_page;
    }

    /**
     * @return string
     */
    public function getPath(): string
    {
        return $this->path;
    }

    /**
     * @return int
     */
    public function getPerPage(): int
    {
        return $this->per_page;
    }

    /**
     * @return int
     */
    public function getTo(): int
    {
        return $this->to;
    }

    /**
     * @return int
     */
    public function getTotal(): int
    {
        return $this->total;
    }
    
    
}
