<?php

namespace Intergo\BaseClient\Responses;

use Throwable;

class ErrorResponse extends AbstractBaseResponse
{
    /**
     * ErrorResponse constructor.
     * @param Throwable $exception
     */
    public function __construct(Throwable $exception)
    {
        $response = [
            'success' => false,
            'message' => $exception->getMessage(),
            'data' => $exception->getTraceAsString()
        ];
        if (method_exists($exception, "hasResponse") && $exception->hasResponse()) {
            $body = $exception->getResponse()->getBody();
            if (!empty($body)) {
                $response = json_decode($body->getContents(), true);
                if (is_null($response)) {
                    $response = [
                        'success' => false,
                        'message' => $exception->getMessage(),
                        'data' => $exception->getTraceAsString()
                    ];
                }
            }
        }
        parent::__construct($response);
    }
}
