<?php

namespace Intergo\BaseClient\Responses;

abstract class AbstractBaseResponse implements BaseResponseInterface
{
    /**
     * @var bool|null
     */
    protected $success;

    /**
     * @var mixed|null
     */
    protected $data;

    /**
     * @var string|null
     */
    protected $message;

    /**
     * @param $response
     */
    public function __construct($response)
    {
        $this->success = $response['success'] ?? null;
        $this->message = $response['message'] ?? null;
        $this->data = $response['data'] ?? null;
    }

    /**
     * @return bool|null
     */
    public function isSuccessful()
    {
        return !empty($this->success);
    }

    /**
     * @return mixed
     */
    public function getData()
    {
        return $this->data;
    }

    /**
     * @return string|null
     */
    public function getMessage()
    {
        return $this->message;
    }
}
