<?php

namespace Intergo\BaseClient\Requests;

use GuzzleHttp\Client;
use GuzzleHttp\Exception\GuzzleException;
use Intergo\BaseClient\Enums\HttpMethodEnum;
use Psr\Http\Message\ResponseInterface;

class RequestHandler
{
    /** @var Client */
    private $curl;

    /**
     * RequestHandler constructor.
     * @param array $config
     */
    public function __construct(array $config = [])
    {
        $this->curl = new Client($config);
    }

    /**
     * @param $method
     * @param string $url
     * @param array $options
     * @return ResponseInterface
     * @throws GuzzleException
     */
    public function request($method, string $url = '', array $options = [])
    {
        return $this->curl->request($method, $url, $options);
    }

    /**
     * @param $url
     * @param array $options
     * @return ResponseInterface
     * @throws GuzzleException
     */
    public function post($url, array $options = [])
    {
        return $this->request(HttpMethodEnum::POST, $url, $options);
    }

    /**
     * @param $url
     * @param array $options
     * @return ResponseInterface
     * @throws GuzzleException
     */
    public function get($url, array $options = [])
    {
        return $this->request(HttpMethodEnum::GET, $url, $options);
    }
}
