<?php

namespace Intergo\BaseClient\Enums;

class BaseEnum
{
    /**
     * @var array
     */
    protected static $names = [];

    /**
     * @param $value
     * @param null $default
     * @return mixed|null
     */
    public static function getName($value, $default = null)
    {
        return static::$names[$value] ?? $default;
    }

    /**
     * @param $name
     * @param null $default
     * @return int|string|null
     */
    public static function getKey($name, $default = null)
    {
        $flip = array_flip(static::$names);
        return $flip[$name] ?? $default;
    }
}
