<?php

namespace Intergo\BaseClient;

use GuzzleHttp\RequestOptions;
use Intergo\BaseClient\Enums\ContentTypes;
use Intergo\BaseClient\Enums\HttpMethodEnum;
use Intergo\BaseClient\Requests\RequestInterface;
use Intergo\BaseClient\Responses\BaseResponse;
use Intergo\BaseClient\Responses\PaginationResponse;
use Intergo\BaseClient\Responses\ErrorResponse;
use Intergo\BaseClient\Responses\BaseResponseInterface;
use Throwable;

abstract class Client
{
    /**
     * @param RequestInterface $request
     * @param array $params
     * @param string $method
     * @return BaseResponseInterface
     */
    protected function processRequest(RequestInterface $request, array $params, string $method = HttpMethodEnum::POST)
    {
        try {
            if ($method === HttpMethodEnum::GET) {
                $response = $request->execute($method, [RequestOptions::QUERY => $this->removeEmptyValues($params)]);
            } else {
                $response = $request->execute($method, [RequestOptions::JSON => $this->removeEmptyValues($params)]);
            }
        } catch (Throwable $exception) {
            return $this->getErrorResponse($exception);
        }

        if (isset($response['current_page']) && isset($response['total'])) {
            return new PaginationResponse($response);
        }

        return $this->getBaseResponse($response);
    }

    /**
     * @param $params
     * @return array
     */
    protected function removeEmptyValues($params)
    {
        return array_filter($params, function ($a) {
            return $a !== null;
        });
    }

    /**
     * @param $exception
     * @return BaseResponseInterface
     */
    protected function getErrorResponse($exception)
    {
        return new ErrorResponse($exception);
    }

    /**
     * @param $response
     * @return BaseResponseInterface
     */
    protected function getBaseResponse($response)
    {
        return new BaseResponse($response);
    }
}
