<?php

namespace Intergo\BaseClient\Responses;

use GuzzleHttp\Exception\RequestException;

class ErrorResponse extends AbstractBaseResponse
{
    /**
     * ErrorResponse constructor.
     * @param RequestException $exception
     */
    public function __construct(RequestException $exception)
    {
        $response = ['message' => $exception->getMessage()];
        if ($exception->hasResponse()) {
            $body = $exception->getResponse()->getBody();
            if (!empty($body)) {
                $response = json_decode($body->getContents(), true);
            }
        }
        parent::__construct($response);
    }
}
