<?php

namespace Intergo\BaseClient\Requests;

use GuzzleHttp\Exception\GuzzleException;
use Psr\Http\Message\ResponseInterface;

interface RequestInterface
{
    /**
     * @param $method
     * @param $options
     * @return mixed|ResponseInterface
     * @throws GuzzleException
     */
    public function execute($method, $options);

    /**
     * @param $method
     * @param array $params
     * @return ResponseInterface
     * @throws GuzzleException
     */
    public function send($method, array $params = []);

    /**
     * @return array
     */
    public function authorizationsHeaders();
}
