<?php

namespace Intergo\BaseClient\Requests;

use Intergo\BaseClient\Enums\ContentTypes;
use GuzzleHttp\Exception\GuzzleException;
use Psr\Http\Message\ResponseInterface;

class BaseRequest implements RequestInterface
{
    /** @var */
    protected $url;

    /** @var RequestHandler */
    protected $http;
    /**
     * @var string
     */
    protected $trace_id;

    /**
     * BaseRequest constructor.
     * @param string $url
     * @param string $trace_id
     * @param array $config
     */
    public function __construct(string $url, string $trace_id = '1', array $config = [])
    {
        $this->url = $url;
        $this->trace_id = $trace_id;
        $this->http = new RequestHandler($config);
    }

    /**
     * @param $method
     * @param $options
     * @return mixed|ResponseInterface
     * @throws GuzzleException
     */
    public function execute($method, $options)
    {
        $response = $this->send($method, array_merge($this->authorizationsHeaders(), $options));
        if (isset($options[ContentTypes::JSON])) {
            return json_decode($response->getBody()->getContents(), true);
        }
        return $response;
    }

    /**
     * @param $method
     * @param array $params
     * @return ResponseInterface
     * @throws GuzzleException
     */
    public function send($method, array $params = [])
    {
        return $this->http->request($method, $this->url, $params);
    }

    /**
     * @return array
     */
    public function authorizationsHeaders()
    {
        return [
            'headers' => [
                'Accept' => ContentTypes::APPLICATION_JSON,
                'Content-Type' => ContentTypes::APPLICATION_JSON,
                'X-TRACE-ID' => $this->trace_id
            ]
        ];
    }
}
