<?php

namespace Intergo\BaseClient\Requests;

use Intergo\BaseClient\Enums\ContentTypes;

class AuthenticationRequest extends BaseRequest implements RequestInterface
{
    /**
     * @var string
     */
    private $bearerToken;

    /**
     * BaseRequest constructor.
     * @param string $url
     * @param string $bearerToken
     * @param string $trace_id
     * @param array $config
     */
    public function __construct(string $url, string $bearerToken, string $trace_id = '1', array $config = [])
    {
        $this->bearerToken = $bearerToken;
        parent::__construct($url, $trace_id, $config);
    }

    /**
     * @return array
     */
    public function authorizationsHeaders()
    {
        return [
            'headers' => [
                'Accept' => ContentTypes::APPLICATION_JSON,
                'Content-Type' => ContentTypes::APPLICATION_JSON,
                'X-TRACE-ID' => $this->trace_id,
                'Authorization' => "Bearer {$this->bearerToken}"
            ]
        ];
    }
}
