<?php

namespace Intergo\BaseClient;

use GuzzleHttp\Exception\GuzzleException;
use Intergo\BaseClient\Enums\ContentTypes;
use Intergo\BaseClient\Enums\HttpMethodEnum;
use Intergo\BaseClient\Requests\RequestInterface;
use Intergo\BaseClient\Responses\BaseResponse;
use Intergo\BaseClient\Responses\ErrorResponse;
use Intergo\BaseClient\Responses\BaseResponseInterface;
use GuzzleHttp\Exception\RequestException;

abstract class Client
{
    /**
     * @param RequestInterface $request
     * @param array $params
     * @param string $method
     * @return BaseResponseInterface
     */
    protected function processRequest(RequestInterface $request, array $params, string $method = HttpMethodEnum::POST)
    {
        try {
            $response = $request->execute($method, [ContentTypes::JSON => $params]);
        } catch (RequestException $exception) {
            return new ErrorResponse($exception);
        } catch (GuzzleException $exception) {
            $requestException = RequestException::create($request, null, $exception);
            return new ErrorResponse($requestException);
        }
        return new BaseResponse($response);
    }
}
