<?php

namespace Intergo\BaseClient;

use Intergo\BaseClient\Enums\HttpMethodEnum;

abstract class ApiHandler
{
    /**
     * Classes that extend ApiHandler should have a list of ENDPOINTS
     * with the following structure:
     *
     * const ENDPOINTS = [
     *    'login' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/auth/login'],
     *    'example => [self::METHOD => HttpMethodEnum::GET, self::URL => '/example/:userId'],
     *     ...
     */

    const METHOD = 'method';
    const URL = 'url';

    abstract static function apiVersion();
    abstract static function getEndpoint($endpoint);

    /**
     * @param $endpoint
     * @param $params
     * @return string
     */
    public static function getUrl($endpoint, $params)
    {
        $parameters = [];
        foreach ($params as $field => $value) {
            $parameters[':' . $field] = $value;
        }
        $url = static::getEndpoint($endpoint)[self::URL] ?? '/';
        return static::apiVersion() . strtr($url, $parameters);
    }

    /**
     * @param $endpoint
     * @return string
     */
    public static function getMethod($endpoint)
    {
        return static::getEndpoint($endpoint)[self::METHOD] ?? HttpMethodEnum::POST;
    }
}
