<?php

namespace Intergo\AuthClient\Helpers;

class IpHelper
{
    /**
     * Validate if the ip in right format
     * @param string $ip
     * @return bool
     */
    public static function isValidIPv4Format(string $ip): bool
    {
        return filter_var($ip, FILTER_VALIDATE_IP, FILTER_FLAG_IPV4);
    }

    /**
     * Validate if the ipv6 in right format
     * @param string $ip
     * @return bool
     */
    public static function isValidIPv6Format(string $ip): bool
    {
        return filter_var($ip, FILTER_VALIDATE_IP, FILTER_FLAG_IPV6);
    }

    /**
     * Validate if the ipv4 has subnet format like 192.168.1.0/24
     * @param string $ip
     * @return bool
     */
    public static function isValidIpv4WithSubnet(string $ip): bool
    {
        $ipV4regexWithMask = '/^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\/(3[0-2]|[1-2]?\d)$/m';
        return preg_match($ipV4regexWithMask, $ip);
    }

    /**
     * Validate if the ipv6 has subnet format like 2001:0db8/32
     * @param string $ip
     * @return bool
     */
    public static function isValidIpv6WithSubnet(string $ip): bool
    {
        $ipV6regexWithMask = '/((?:(?:(?:[0-9a-fA-F]){1,4}):){1,4}:[^\s:]\d{0,2})/m';
        return preg_match($ipV6regexWithMask, $ip);
    }
}