<?php

namespace Intergo\AuthClient\Enums;

class ErrorCodeEnum
{
    const INVALID_LOGIN_CREDENTIALS = 0;

    /** From https://intergo.atlassian.net/wiki/spaces/SMSD/pages/1660387332/User+Error+Codes **/
    const BANNED_FAILED_DETAILS = 1001;
    const BANNED_SPAM_USER = 1002;
    const BANNED_LOW_QUALITY = 1003;
    const BANNED_URL_SCANNER = 1004;
    const BANNED_SPAM_FILTER = 1005;
    const BANNED_STOP_FORUM_LAST_LOGIN_IP = 1006;
    const BANNED_STOP_FORUM_SIGNUP_IP = 1007;
    const BANNED_STOP_FORUM_SIGNUP_EMAIL = 1008;
    const BANNED_DUPLICATE_IP = 1009;
    const BANNED_2FA_NUMBERS_IN_BANLIST = 1010;
    const BANNED_OTHER_REASON = 1011;
    const RESET_PASSWORD_USE_EMAIL_OF_NO_USER = 1012;
    const EXPIRED_PASSWORD_USAGE = 1014;

    const BLACKLISTED_EMAIL = 2001;
    const BLACKLISTED_IP = 2002;
    const IP_RATE_FAILED_LOGIN_LIMITER = 2003;
    const IP_RATE_MAX_REGISTRATION = 2004;
    const EMAIL_EXISTS = 2005;
    const EMAIL_VALIDATION = 2006;
    const DUPLICATE_GMAIL = 2007;
    const DISPOSABLE_EMAIL_DOMAIN = 2008;
    const FREE_EMAIL_DOMAIN = 2009;

    const DISAPPROVED_ACCOUNT = 3001;
    const UNVERIFIED_ACCOUNT = 3002;
    const INACTIVE = 3004;
}