<?php

namespace Intergo\AuthClient;

trait AuthUserTrait
{
    /**
     * @param array $attributes
     * @return AuthUser
     */
    private function toAuth(array $attributes)
    {
        return new AuthUser($attributes);
    }

    /**
     * @param string $permission
     * @return bool
     */
    public function checkPermission(string $permission)
    {
        if (empty($this->auth())) {
            return false;
        }
        $authUser = $this->toAuth($this->auth());
        return in_array($permission, $authUser->permissions);
    }

    /**
     * @param $permissions
     * @return bool
     */
    public function hasAnyPermission($permissions)
    {
        foreach ($permissions as $permission) {
            if ($this->checkPermission($permission)) {
                return true;
            }
        }
        return false;
    }

    public function hasRole($role)
    {
        if (empty($this->auth())) {
            return false;
        }
        $authUser = $this->toAuth($this->auth());
        return in_array($role, $authUser->roles);
    }
}
