<?php
namespace Intergo\AuthClient;

use Intergo\BaseClient\Client;
use Intergo\BaseClient\Requests\BaseRequest;
use Intergo\BaseClient\Responses\BaseResponseInterface;

class AuthClient extends Client
{
    /**
     * @return BaseResponseInterface
     */
    public function execute($endpoint, $baseUrl, $urlParams, $bodyParams, $traceId)
    {
        $url = $baseUrl . AuthApiHandler::getUrl($endpoint, $urlParams);
        $request = new BaseRequest($url, $traceId);
        return $this->processRequest($request, $bodyParams, AuthApiHandler::getMethod($endpoint));
    }
}
