<?php

namespace Intergo\AuthClient;

use Intergo\BaseClient\ApiHandler;
use Intergo\BaseClient\Enums\HttpMethodEnum;

class AuthApiHandler extends ApiHandler
{
    protected static $endpoints = [
        /** ########### AUTH ########### */
        'register' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/auth/register'],
        'login' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/auth/login'],
        'loginBy' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/auth/login/by'],
        'verifyUser' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/oauth/verify'],
        'authenticate' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/auth/authenticate'],
        'refresh' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/auth/refresh'],
        'invalidate' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/auth/invalidate'],
        'regenerateVerificationCode' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/auth/regenerate/verification-code'],
        'verifyEmail' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/auth/email/verify'],
        'invalidateUser' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/auth/email/invalidateUser'],

        /** ########### API KEY ########### */
        'getUserApiKeys' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/users/api/key'],
        'generateApiKey' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/users/api/key/generate'],
        'disableApiKey' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/users/api/key/disable'],
        'enableApiKey' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/users/api/key/enable'],
        'deleteApiKey' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/users/api/key/delete'],
        'deleteUserApiKeys' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/users/api/key/user/delete'],

        /** ########### API CLIENTS ########### */
        'getUserApiClients' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/users/api/key/client'],
        'generateApiClient' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/users/api/key/client/generate'],
        'disableApiClient' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/users/api/key/client/disable'],
        'enableApiClient' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/users/api/key/client/enable'],
        'deleteApiClient' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/users/api/key/client/delete'],

        /** ########### ROLES & PERMISSIONS ########### */
        'getRoles' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/admin/roles'],
        'getRolesForUser' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/admin/roles/users/get'],
        'hasHigherRoleThan' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/admin/roles/users/check/:user_id'],
        'getUsersRolesAndPermissions' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/admin/roles/users/all'],
        'searchForUser' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/admin/roles/users/search'],
        'assignOrRevokeRoles' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/admin/roles/assign-or-revoke'],
        'storeRole' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/admin/roles/store'],
        'updateRole' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/admin/roles/update'],
        'deleteRole' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/admin/roles/delete'],
        'getPermissions' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/admin/permissions'],
        'getPermissionsForUser' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/admin/permissions/users/get'],

        /** ########### BANLISTS & WHITELISTS ########### */
        'getEmailBanlist' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/admin/rules/emailbanlist'],
        'addEmailBanlist' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/admin/rules/emailbanlist/add'],
        'editEmailBanlist' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/admin/rules/emailbanlist/edit'],
        'removeEmailBanlist' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/admin/rules/emailbanlist/remove'],

        'getEmailWhitelist' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/admin/rules/emailwhitelist'],
        'addEmailWhitelist' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/admin/rules/emailwhitelist/add'],
        'editEmailWhitelist' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/admin/rules/emailwhitelist/edit'],
        'removeEmailWhitelist' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/admin/rules/emailwhitelist/remove'],

        'getIpBanlist' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/admin/rules/ipbanlist'],
        'addIpBanlist' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/admin/rules/ipbanlist/add'],
        'editIpBanlist' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/admin/rules/ipbanlist/edit'],
        'removeIpBanlist' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/admin/rules/ipbanlist/remove'],


        'getIpWhitelist' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/admin/rules/ipwhitelist'],
        'addIpWhitelist' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/admin/rules/ipwhitelist/add'],
        'editIpWhitelist' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/admin/rules/ipwhitelist/edit'],
        'removeIpWhitelist' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/admin/rules/ipwhitelist/remove'],

        /** ########### ADMIN ########### */
        'approveUser' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/admin/users/approve'],
        'disapproveUser' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/admin/users/disapprove'],
    ];
}
