<?php

namespace Intergo\AuthClient\Rules;

use Illuminate\Contracts\Validation\Rule;
use Intergo\AuthClient\Helpers\IpHelper;

/**
 * Purpose: validate IP format IPV4/IPV6
 * Use this in case you will receive IP in your request
 */
class IpValidationRule implements Rule
{

    /**
     * Determine if the validation rule passes.
     *
     * @param string $attribute
     * @param mixed $value
     * @return bool
     */
    public function passes($attribute, $value): bool
    {
        return IpHelper::isValidIPv4Format($value) || IpHelper::isValidIPv6Format($value) ||
              IpHelper::isValidIpv4WithSubnet($value) || IpHelper::isValidIpv6WithSubnet($value);
    }


    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message(): string
    {
        return 'Invalid IP format. Please provide a valid IPV4/IPV6.';
    }
}
