<?php

namespace Intergo\AuthClient\Helpers;

use Intergo\AuthClient\Rules\PasswordRule;

class PasswordHelper
{
    /**
     * @return string
     */
    public static function generate(): string
    {
        // Define character sets
        $uppercaseChars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $lowercaseChars = 'abcdefghijklmnopqrstuvwxyz';
        $digitChars = '0123456789';
        $specialChars = '!@#$%^&*()-_+=~`[]{}|:;"\',.<>?';

        // Combine all character sets
        $allChars = $uppercaseChars . $lowercaseChars . $digitChars . $specialChars;

        // Generate random password of random length within specified range
        $passwordLength = mt_rand(PasswordRule::MIN_LENGTH, PasswordRule::MAX_LENGTH);

        $password = '';
        // Ensure at least one character from each set
        $password .= $uppercaseChars[mt_rand(0, strlen($uppercaseChars) - 1)];
        $password .= $lowercaseChars[mt_rand(0, strlen($lowercaseChars) - 1)];
        $password .= $digitChars[mt_rand(0, strlen($digitChars) - 1)];
        $password .= $specialChars[mt_rand(0, strlen($specialChars) - 1)];

        // Fill the rest of the password with random characters
        for ($i = strlen($password); $i < $passwordLength; $i++) {
            $password .= $allChars[mt_rand(0, strlen($allChars) - 1)];
        }

        // Shuffle the password
        return str_shuffle($password);
    }
}
