<?php

namespace Intergo\AuthClient\Enums;

class UserStatusEnum
{
    const ACTIVE = 'active';
    const INACTIVE = 'inactive';
    const PRE_ACTIVE = 'pre_active';

    const INACTIVE_PERIOD_IN_MONTHS = 6;
    const BULK_ACTION_CHUNK = 5000;

    /**
     * @param $status
     * @return bool
     */
    public static function isEligibleToBeActive($status): bool
    {
        return in_array($status, [
            self::PRE_ACTIVE,
            self::INACTIVE
        ]);
    }
}