<?php

namespace Intergo\AuthClient;

use Intergo\BaseClient\ApiHandler;
use Intergo\BaseClient\Enums\HttpMethodEnum;

class AuthApiHandler extends ApiHandler
{
    protected static array $endpoints = [
        /** ########### AUTH ########### */
        'register' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/auth/register'],
        'login' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/auth/login'],
        'loginBy' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/auth/login/by'],
        'refresh' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/auth/refresh'],
        'invalidate' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/auth/invalidate'],
        'regenerateVerificationCode' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/auth/regenerate/verification-code'],
        'verifyEmail' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/auth/email/verify'],
        'invalidateUserModel' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/auth/user/invalidate'],
        'resetPassword' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/auth/user/password/reset'],

        /** ########### INTERNAL AUTH ########### */
        'authenticateWeb' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/auth/web/authenticate', self::INTERNAL => true],
        'authenticateApi' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/auth/api/authenticate', self::INTERNAL => true],


        /** ########### API KEY ########### */
        'getUserApiKeys' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/users/api/keys'],
        'generateApiKey' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/users/api/keys/generate'],
        'disableApiKey' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/users/api/keys/disable'],
        'enableApiKey' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/users/api/keys/enable'],
        'deleteApiKey' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/users/api/keys/delete'],
        'deleteUserApiKeys' => [self::METHOD => HttpMethodEnum::DELETE, self::URL => '/users/:user_id/api/keys', self::INTERNAL => true],
        'getUserWebApiKey' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/users/:user_id/api/keys/web', self::INTERNAL => true],
        'getApiKeysByUserId' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/users/:user_id/api/keys', self::INTERNAL => true],

        /** ########### API CLIENTS ########### */
        'getUserApiClients' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/users/api/clients'],
        'generateApiClient' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/users/api/clients/generate'],
        'disableApiClient' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/users/api/clients/disable'],
        'enableApiClient' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/users/api/clients/enable'],
        'deleteApiClient' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/users/api/clients/delete'],

        /** ########### USERS ########### */
        'changePassword' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/users/password/change'],
        'getUserDetail' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/user/:user_id/details'],
        'getUsersDetails' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/users/details', self::INTERNAL => true],
        'getUsersQueues' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/users/queues', self::INTERNAL => true],
        'searchUser' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/user/search'],
        'updateUser' => [self::METHOD => HttpMethodEnum::PATCH, self::URL => '/users/update'],
        'removeSendingRestriction' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/users/remove-sending-restriction'],
        'setUserAsPreActive' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/users/:user_id/pre-active', self::INTERNAL => true],
        'setUserAsInactive' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/users/:user_id/inactive', self::INTERNAL => true],

        /** ########### ROLES & PERMISSIONS ########### */
        'getRoles' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/admin/roles'],
        'getRolesForUser' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/admin/roles/users/get'],
        'hasHigherRoleThan' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/admin/roles/users/check/:user_id'],
        'getUsersRolesAndPermissions' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/admin/roles/users/all'],
        'searchForUser' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/admin/roles/users/search'],
        'searchForManagers' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/admin/roles/managers/search'],
        'assignOrRevokeRoles' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/admin/roles/assign-or-revoke'],
        'storeRole' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/admin/roles/store'],
        'updateRole' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/admin/roles/update'],
        'deleteRole' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/admin/roles/delete'],
        'getPermissions' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/admin/permissions'],
        'getPermissionsForUser' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/admin/permissions/users/get'],

        /** ########### BANLISTS & WHITELISTS ########### */
        'getEmailBanlist' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/admin/rules/emailbanlist'],
        'addEmailBanlist' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/admin/rules/emailbanlist/add'],
        'editEmailBanlist' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/admin/rules/emailbanlist/edit'],
        'removeEmailBanlist' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/admin/rules/emailbanlist/remove'],

        'getEmailWhitelist' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/admin/rules/emailwhitelist'],
        'addEmailWhitelist' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/admin/rules/emailwhitelist/add'],
        'editEmailWhitelist' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/admin/rules/emailwhitelist/edit'],
        'removeEmailWhitelist' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/admin/rules/emailwhitelist/remove'],

        'getIpBanlist' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/admin/rules/ipbanlist'],
        'addIpBanlist' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/admin/rules/ipbanlist/add'],
        'editIpBanlist' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/admin/rules/ipbanlist/edit'],
        'removeIpBanlist' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/admin/rules/ipbanlist/remove'],

        'getIpWhitelist' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/admin/rules/ipwhitelist'],
        'addIpWhitelist' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/admin/rules/ipwhitelist/add'],
        'editIpWhitelist' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/admin/rules/ipwhitelist/edit'],
        'removeIpWhitelist' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/admin/rules/ipwhitelist/remove'],

        'getEmailStopforum' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/admin/rules/emailstopforum'],

        'getFreeEmailBanlist' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/admin/rules/freeemailbanlist'],
        'addFreeEmailBanlist' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/admin/rules/freeemailbanlist/add'],
        'editFreeEmailBanlist' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/admin/rules/freeemailbanlist/edit'],
        'removeFreeEmailBanlist' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/admin/rules/freeemailbanlist/remove'],

        'clearIPRateEvent' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/admin/rules/iprate/event/clear'],

        /** ########### RULES ########### */
        'validateRules' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/rules/validate/:action'],
        'validateStopforumip' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/rules/stopforumip'],
        'validateStopforumtoxicemail' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/rules/stopforumtoxicemail'],
        'validateDuplicateip' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/rules/duplicateip'],
        'validateEmailbanlist' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/rules/emailbanlist'],
        'validateIpbanlist' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/rules/ipbanlist'],
        'validateUserstatus' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/rules/userstatus'],
        'validateEmailvalidation' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/rules/emailvalidation'],
        'validateDuplicategmail' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/rules/duplicategmail'],
        'validateDisposableemaildomain' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/rules/disposableemaildomain'],
        'validateFreeemaildomain' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/rules/freeemaildomain'],

        /** ########### Webhook Secrets ########### */
        'getWebhookSecret' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/user/:user_id/webhook-secret'],
        'getUserWebhookSecrets' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/users/webhook-secrets'],
        'updateUserWebhookSecret' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/users/webhook-secrets/updateSecret'],

        /** ########### ADMIN ########### */
        'approveUser' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/admin/users/approve'],
        'disapproveUser' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/admin/users/disapprove'],
        'banUser' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/admin/users/:user_id/ban'],
        'unbanUser' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/admin/users/:user_id/unban'],
        'restoreUser' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/admin/users/:user_id/restore'],
        'assignService' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/admin/users/:user_id/services/assign/:service_name'],
        'revokeService' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/admin/users/:user_id/services/revoke/:service_name'],
        'updateUserByAdmin' => [self::METHOD => HttpMethodEnum::PATCH, self::URL => '/admin/users/:user_id'],
        'updateSendingRestriction' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/admin/users/:user_id/update-sending-restriction'],
        'getActivityStats' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/admin/kpi/activity'],

        /** ########### BALANCE ENDPOINT ########### */
        'addBalance' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/user/:user_id/balance/add'],
        'deductBalance' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/user/:user_id/balance/deduct'],
        'getUserLegacyBalance' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/user/balance'],
    ];
}
