<?php

namespace Intergo\ActivityLogClient;

use Intergo\BaseClient\ApiHandler;
use Intergo\BaseClient\Enums\HttpMethodEnum;

class ActivityLogApiHandler extends ApiHandler
{
    protected static array $endpoints = [
        //Admin Activities
        'logAdminActivity' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/activities/admin', self::INTERNAL => true],
        'searchAdminActivities' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/activities/admin', self::INTERNAL => true],

        //Member Activities
        'logMemberActivity' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/activities/member', self::INTERNAL => true],
        'searchMemberActivities' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/activities/member', self::INTERNAL => true],

        //Access Management Activities
        'logAccessActivity' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/activities/access', self::INTERNAL => true],
        'searchAccessActivities' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/activities/access', self::INTERNAL => true],

        //General
        'getDistinctPerformedBy' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/activities/:type/performed-by', self::INTERNAL => true],
        'getDistinctPerformedTo' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/activities/:type/performed-to', self::INTERNAL => true],
        'getDistinctActions' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/activities/:type/actions', self::INTERNAL => true],
    ];
}
