<?php

namespace Intergo\ActivityLogClient;

use Intergo\BaseClient\Responses\BaseResponseInterface;

abstract class AbstractActivityLogService
{
    private ActivityLogClient $client;

    /**
     * ActivityLogService constructor.
     *
     * @param $baseUrl
     * @param $traceId
     */
    public function __construct($baseUrl, $traceId)
    {
        $this->client = new ActivityLogClient($baseUrl, $traceId);
    }

    /**
     * @param $endpoint
     * @param array $urlParams
     * @param array $bodyParams
     * @return BaseResponseInterface
     */
    protected function execute($endpoint, array $urlParams = [], array $bodyParams = [])
    {
        $result = $this->client->execute($endpoint, $urlParams, $bodyParams);
        return $this->response($endpoint, $result);
    }

    /**
     * @param $endpoint
     * @param $token
     * @param array $bodyParams
     * @param array $urlParams
     * @return BaseResponseInterface
     */
    protected function executeAuth($endpoint, $token, array $bodyParams = [], array $urlParams = [])
    {
        $result = $this->client->executeAuth($endpoint, $token, $urlParams, $bodyParams);
        return $this->response($endpoint, $result);
    }

    /**
     * @param string $action
     * @param BaseResponseInterface $result
     * @return BaseResponseInterface
     */
    abstract public function response(string $action, BaseResponseInterface $result);

    /**
     * @param $action
     * @param $event
     * @param $reason
     * @param $performed_by
     * @param $performed_to
     * @return BaseResponseInterface
     */
    public function logAdminActivity($action, $event, $reason, $performed_by, $performed_to = null)
    {
        return $this->execute(__FUNCTION__, [], compact('action', 'event', 'reason', 'performed_by', 'performed_to'));
    }

    /**
     * @param $queryString
     * @return BaseResponseInterface
     */
    public function searchAdminActivities($queryString)
    {
        if (is_string($queryString)) {
            parse_str($queryString, $queryString);
        }

        extract($queryString);
        unset($queryString);

        return $this->execute(__FUNCTION__, [], get_defined_vars());
    }

    /**
     * @return BaseResponseInterface
     */
    public function getAdminDistinctFilters()
    {
        return $this->execute(__FUNCTION__);
    }
}
