<?php

namespace Intergo\ActivityLogClient;

use Intergo\BaseClient\Responses\BaseResponseInterface;

abstract class AbstractActivityLogService
{
    private ActivityLogClient $client;

    /**
     * ActivityLogService constructor.
     *
     * @param $baseUrl
     * @param $traceId
     */
    public function __construct($baseUrl, $traceId)
    {
        $this->client = new ActivityLogClient($baseUrl, $traceId);
    }

    /**
     * @param $endpoint
     * @param array $urlParams
     * @param array $bodyParams
     * @return BaseResponseInterface
     */
    protected function execute($endpoint, array $urlParams = [], array $bodyParams = [])
    {
        $result = $this->client->execute($endpoint, $urlParams, $bodyParams);
        return $this->response($endpoint, $result);
    }

    /**
     * @param string $action
     * @param BaseResponseInterface $result
     * @return BaseResponseInterface
     */
    abstract public function response(string $action, BaseResponseInterface $result);

    /**
     * @param $action
     * @param $event
     * @param $performed_by
     * @param $performed_to
     * @param $date
     * @return BaseResponseInterface
     */
    public function logAdminActivity($action = null, $event = null, $performed_by = null, $performed_to = null, $date = null)
    {
        return $this->execute(__FUNCTION__, [], compact('action', 'event', 'performed_by', 'performed_to', 'date'));
    }

    /**
     * @param $queryString
     * @return BaseResponseInterface
     */
    public function searchAdminActivities($queryString)
    {
        if (is_string($queryString)) {
            parse_str($queryString, $queryString);
        }

        extract($queryString);
        unset($queryString);

        return $this->execute(__FUNCTION__, [], get_defined_vars());
    }

    /**
     * @return BaseResponseInterface
     */
    public function getAdminDistinctFilters()
    {
        return $this->execute(__FUNCTION__);
    }
}
